# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Configure the Products list in a catalog site
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the site collection
$siteUrl = "http://sharepoint/sitecollection"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the site collection
$site = Get-SPSite $siteUrl
	
# Open a new taxonomy session from the site
$session = Get-SPTaxonomySession -Site $site

# Get the Products term set
$termStore = $session.TermStores[0]
$group = $termStore.Groups["PowerShell Product Categories"]
$termSet = $group.TermSets["Products"]

# Get the Products list
$list = $site.RootWeb.Lists["Products"]

# Add a new metadata field to the Products list
$field = [Microsoft.SharePoint.Taxonomy.TaxonomyField] $list.Fields.CreateNewField("TaxonomyFieldType", "PowerShell Category")
$field.AnchorId = [System.Guid]::Empty
$field.SspId = $termStore.Id
$field.Group = "PowerShell Product Categories"
$field.TermSetId = $termSet.Id
$field.AllowMultipleValues = $false
$list.Fields.Add($field)
$list.Update()

# Get the Red, Green, and Blue terms from the Widgets term
$termWidgets = $termSet.Terms["Widgets"]
$termRed = $termWidgets.Terms["Red"]
$termGreen = $termWidgets.Terms["Green"]
$termBlue = $termWidgets.Terms["Blue"]

# Get the metadata field from the Products list
$field = [Microsoft.SharePoint.Taxonomy.TaxonomyField] $list.Fields["PowerShell Category"]

# Create taxonomy values for the Red, Green, and Blue terms
$valueRed = New-Object Microsoft.SharePoint.Taxonomy.TaxonomyFieldValue -ArgumentList $field
$valueRed.TermGuid = $termRed.Id.ToString()
$valueRed.Label = $termRed.Name
$valueGreen = New-Object Microsoft.SharePoint.Taxonomy.TaxonomyFieldValue -ArgumentList $field
$valueGreen.TermGuid = $termGreen.Id.ToString()
$valueGreen.Label = $termGreen.Name
$valueBlue = New-Object Microsoft.SharePoint.Taxonomy.TaxonomyFieldValue -ArgumentList $field
$valueBlue.TermGuid = $termBlue.Id.ToString()
$valueBlue.Label = $termBlue.Name

# Add items to the list with the term values
$item001 = $list.Items.Add()
$item001["Title"] = "PowerShell Widget A"
$item001["Item Number"] = "P001"
$item001["PowerShell Category"] = $valueBlue
$item001.Update()
$item002 = $list.Items.Add()
$item002["Title"] = "PowerShell Widget B"
$item002["Item Number"] = "P002"
$item002["PowerShell Category"] = $valueBlue
$item002.Update()
$item003 = $list.Items.Add()
$item003["Title"] = "PowerShell Widget C"
$item003["Item Number"] = "P003"
$item003["PowerShell Category"] = $valueRed
$item003.Update()
$item004 = $list.Items.Add()
$item004["Title"] = "PowerShell Widget D"
$item004["Item Number"] = "P004"
$item004["PowerShell Category"] = $valueRed
$item004.Update()
$item005 = $list.Items.Add()
$item005["Title"] = "PowerShell Widget E"
$item005["Item Number"] = "P005"
$item005["PowerShell Category"] = $valueGreen
$item005.Update()
$item006 = $list.Items.Add()
$item006["Title"] = "PowerShell Widget F"
$item006["Item Number"] = "P006"
$item006["PowerShell Category"] = $valueGreen
$item006.Update()

# Update the list
$list.Update()

# Set each the moderation status of each item to approved
$item001.ModerationInformation.Status = "Approved"
$item001.Update()
$item002.ModerationInformation.Status = "Approved"
$item002.Update()
$item003.ModerationInformation.Status = "Approved"
$item003.Update()
$item004.ModerationInformation.Status = "Approved"
$item004.Update()
$item005.ModerationInformation.Status = "Approved"
$item005.Update()
$item006.ModerationInformation.Status = "Approved"
$item006.Update()

# Create a generic list of field names for the URL fields of the catalog list
$urlFields = New-Object -TypeName System.Collections.Generic.List[System.String]
$urlFields.Add("Title")
$urlFields.Add("Item Number")

# Create a CatalogTaxonomyFieldSettings object to configure the navigation hierarchy of the catalog list
$taxFieldSetting = New-Object -TypeName Microsoft.SharePoint.Publishing.CatalogTaxonomyFieldSettings
$field = $list.Fields["PowerShell Category"]
$taxFieldSetting.TermId = $field.AnchorId
$taxFieldSetting.TermSetId = $termSet.Id
$taxFieldSetting.TermStoreId = $termStore.Id
$taxFieldSetting.FieldId = $field.Id
$taxFieldSetting.FieldManagedPropertyName = "owstaxid" + $field.InternalName
$taxFieldSetting.IsSelected = $true
$taxFieldSetting.FieldDisplayName = $field.StaticName

# Publish the catalog list
[Microsoft.SharePoint.Publishing.PublishingCatalogUtility]::PublishCatalog($site.RootWeb, $list, $true, $urlFields, $taxFieldSetting)

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 